<?php
/**
 * @author    Oliver Schieche <php-common@schieche.email>
 * @copyright 2018 Oliver Schieche
 */
namespace Ghoti\Tools\Common\Hydrator;

/**
 * Interface HydratorInterface
 * @package Ghoti\Tools\Common\Hydrator
 */
interface HydratorInterface
{
    /**
     * @param HydratableInterface $object
     * @param array $data
     * @return mixed
     */
    public function hydrate(HydratableInterface $object, array $data);

    /**
     * @param HydratableInterface $object
     * @return array
     */
    public function extract(HydratableInterface $object): array;
}