<?php
/**
 * @author    Oliver Schieche <php-common@schieche.email>
 * @copyright 2018 Oliver Schieche
 */
namespace Ghoti\Tools\Common\Configuration\Source;

use Ghoti\Tools\Common\Configuration\ConfigurationInterface;
use Ghoti\Tools\Common\Exception\RuntimeException;
use Ghoti\Tools\Common\Os\Filename;

/**
 * Class File
 * @package Ghoti\Tools\Common\Application
 */
class File implements ConfigurationInterface
{
    /** @var string */
    protected $configurationFile;

    /**
     * File constructor.
     *
     * @param string $configurationFile
     * @throws \Ghoti\Tools\Common\Exception\FileNotFoundException
     */
    public function __construct($configurationFile)
    {
        $this->configurationFile = Filename::absolutize($configurationFile);
    }

    /**
     * @return array
     * @throws \Ghoti\Tools\Common\Exception\RuntimeException
     */
    public function getConfiguration(): array
    {
        /** @noinspection PhpIncludeInspection */
        $config = require $this->configurationFile;

        if (!\is_array($config)) {
            throw new RuntimeException(\sprintf('"%s" did not yield an array for use as configuration data', $this->configurationFile));
        }

        return $config;
    }
}
