<?php
/**
 * @author    Oliver Schieche <php80c@spam.oliver-schieche.de>
 * @copyright 2022
 */
use PHPUnit\Framework\TestCase;

/**
 * Class ArrayIsListTest
 *
 * @author oliver.schieche
 */
class ArrayIsListTest extends TestCase
{
    /**
     * @return void
     */
    public function testIfItWorks()
    {
        // Keys are in order (x4)
        $this->assertTrue(array_is_list([]));
        $this->assertTrue(array_is_list([0, 1, 2, 3]));
        $this->assertTrue(array_is_list([0, 'one', 2, 'three']));
        $this->assertTrue(array_is_list([0 => 'zero', 1 => 'one', 2, 3]));
        $this->assertTrue(array_is_list([0 => 1, 1 => 2, 2 => 3, 3 => 4]));

        // Keys not in order (x2)
        $this->assertFalse(array_is_list([1 => 0, 'four']));
        $this->assertFalse(array_is_list([1 => 0, 0 => 1]));

        // non-consecutive indices (x1)
        $this->assertFalse(array_is_list([0 => 'zero', 2 => 'two', 3 => 'three', 4 => 'four']));

        // non-numeric indices (x2)
        $this->assertFalse(array_is_list([0, 1, 2, 'foo' => 'bar']));
        $this->assertFalse(array_is_list(['key' => 'value', 'another' => 'assoc']));
    }
}
