<?php
declare(strict_types=1);
/**
 * @author    Oliver Schieche <php80c@spam.oliver-schieche.de>
 * @copyright 2022
 */

/**
 * Checks whether a given array is a list
 *
 * @param array $array
 * @return bool
 * @see https://www.php.net/manual/en/function.array-is-list.php
 */
function array_is_list(array $array): bool
{
    $n = 0;
    foreach ($array as $key => $value) {
        if ($key !== $n++) {
            return false;
        }
    }

    return true;
}
