<?php
/**
 * @author    Oliver Schieche <github+atlassian-client@spam.oliver-schieche.de>
 * @copyright 2019
 */
namespace Ghoti\Test\Lib\AtlassianClient\Jira;

use Ghoti\AtlassianClient\Jira\Client\JiraClientFactory;
use Ghoti\AtlassianClient\Jira\Client\JiraClient;
use PHPUnit\Framework\TestCase;

/**
 * Class JiraClientFactoryTest
 *
 * @package Ghoti\Test\Lib\AtlassianClient\Jira
 */
class JiraClientFactoryTest extends TestCase
{
    public function test_Factory_InstantiationWithoutAuthentication_shouldSucceed()
    {
        $factory = new JiraClientFactory();
        $client = $factory->createClient('https://example.com');

        $this->assertInstanceOf(JiraClient::class, $client);
    }

    public function test_Factory_InstantiationWithAuthentication_shouldSucceed()
    {
        $factory = new JiraClientFactory();
        $client = $factory->createClient('https://example.com', 'f00bert', 'p455w0RD');

        $this->assertInstanceOf(JiraClient::class, $client);
    }
}
