<?php
/**
 * @author    Oliver Schieche <github+atlassian-client@spam.oliver-schieche.de>
 * @copyright 2019
 */
namespace Ghoti\Test\Lib\AtlassianClient\Jira\Issue;

use Ghoti\AtlassianClient\Jira\Issue\Field\JiraIssueField;
use Ghoti\AtlassianClient\Jira\Issue\JiraIssueFactory;
use PHPUnit\Framework\TestCase;

/**
 * Class JiraIssueTest
 *
 * @package Ghoti\Test\Lib\AtlassianClient\Jira\Issue
 */
class JiraIssueTest extends TestCase
{
    public function test_IssueFactory_withHydration_shouldSucceed()
    {
        $issue = JiraIssueFactory::create([
            'id' => 13337,
            'key' => 'JIRA-7331',
            'self' => 'https://jira.example.com/issue/JIRA-7331',
            'fields' => [
                'summary' => 'Another JIRA issue'
            ]
        ]);

        $this->assertSame(13337, $issue->getId());
        $this->assertNotSame('13337', $issue->getId());
        $this->assertEquals('JIRA-7331', $issue->getKey());
        $this->assertEquals('https://jira.example.com/issue/JIRA-7331', $issue->getUrl());
        $this->assertNull($issue->getField('gork'));

        $field = $issue->getField('summary');
        $this->assertInstanceOf(JiraIssueField::class, $field);
        $this->assertEquals('summary', $field->getKey());
        $this->assertEquals('Another JIRA issue', $field->getValue());
    }
}
