<?php
declare(strict_types=1);
/**
 * @author    Oliver Schieche <github+atlassian-client@spam.oliver-schieche.de>
 * @copyright 2019-2021
 */
namespace Ghoti\AtlassianClient\Jira\Client;

use GuzzleHttp\Client;
use GuzzleHttp\ClientInterface;

/**
 * Class JiraClientFactory
 *
 * @package Ghoti\AtlassianClient\Jira\Client
 */
class JiraClientFactory
{
    /**
     * @param string $url
     * @param string|null $username
     * @param string|null $password
     * @return JiraClient
     */
    public function createClient(string $url, string $username = null, string $password = null): JiraClient
    {
        $httpParams = ['base_uri' => $url];

        if (null !== $username) {
            $httpParams['auth'] = [$username, $password];
        }

        $httpClient = $this->createClientInstance($httpParams);
        return new JiraClient($httpClient);
    }

    /**
     * @param array<string,string|array> $parameters
     * @return ClientInterface
     */
    protected function createClientInstance(array $parameters): ClientInterface
    {
        return new Client($parameters);
    }
}
