<?php
declare(strict_types=1);
/**
 * @author    Oliver Schieche <github+atlassian-client@spam.oliver-schieche.de>
 * @copyright 2019-2021
 */
namespace Ghoti\AtlassianClient\Jira\Issue;

use Ghoti\AtlassianClient\Contracts\HydratorInterface;

/**
 * Class JiraIssueHydrator
 *
 * @package Ghoti\AtlassianClient\Jira\Issue
 */
class JiraIssueHydrator implements HydratorInterface
{
    /**
     * @param JiraIssue $object
     * @param array<string,mixed> $data
     * @return void
     */
    public function hydrate($object, array $data): void
    {
        $object->setId((int) $data['id'])
            ->setKey($data['key'])
            ->setUrl($data['self']);

        foreach ($data['fields'] as $key => $value) {
            $object->setField($key, $value);
        }
    }
}
