<?php
declare(strict_types=1);
/**
 * @author    Oliver Schieche <github+atlassian-client@spam.oliver-schieche.de>
 * @copyright 2019-2021
 */
namespace Ghoti\AtlassianClient\Jira\Issue;

/**
 * Class JiraIssueFactory
 *
 * @package Ghoti\AtlassianClient\Jira\Issue
 */
class JiraIssueFactory
{
    /**
     * @param array<string,mixed> $data
     * @return JiraIssue
     */
    public static function create(array $data): JiraIssue
    {
        $issue = new JiraIssue();
        $hydrator = new JiraIssueHydrator();
        $hydrator->hydrate($issue, $data);

        return $issue;
    }
}
