<?php
declare(strict_types=1);
/**
 * @author    Oliver Schieche <github+atlassian-client@spam.oliver-schieche.de>
 * @copyright 2019-2021
 */
namespace Ghoti\AtlassianClient\Jira\Issue\Field;

/**
 * Class JiraIssueFieldFactory
 *
 * @package Ghoti\AtlassianClient\Jira\Issue\Field
 */
class JiraIssueFieldFactory
{
    /**
     * @param string $key
     * @param mixed $value
     * @return JiraIssueField
     */
    public static function create(string $key, $value): JiraIssueField
    {
        return (new JiraIssueField)->setKey($key)->setValue($value);
    }
}
