<?php
declare(strict_types=1);
/**
 * @author    Oliver Schieche <github+atlassian-client@spam.oliver-schieche.de>
 * @copyright 2019-2021
 */
namespace Ghoti\AtlassianClient\Jira\Issue\Field;

/**
 * Class JiraIssueField
 *
 * @package Ghoti\AtlassianClient\Jira\Issue\Field
 */
class JiraIssueField
{
    /** @var string */
    protected $key;
    /** @var bool */
    protected $modified = false;
    /** @var mixed */
    protected $value;

    /**
     * @return string
     */
    public function getKey(): string
    {
        return $this->key;
    }

    /**
     * @param string $key
     * @return JiraIssueField
     */
    public function setKey(string $key): JiraIssueField
    {
        $this->key = $key;
        return $this;
    }

    /**
     * @return bool
     */
    public function isModified(): bool
    {
        return $this->modified;
    }

    /**
     * @param bool $modified
     * @return JiraIssueField
     */
    public function setModified(bool $modified): JiraIssueField
    {
        $this->modified = $modified;
        return $this;
    }

    /**
     * @return mixed
     */
    public function getValue()
    {
        return $this->value;
    }

    /**
     * @param mixed $value
     * @return JiraIssueField
     */
    public function setValue($value): JiraIssueField
    {
        if ($value !== $this->value) {
            $this->setModified(true);
        }

        $this->value = $value;
        return $this;
    }
}
